﻿#pragma   once

struct MenuItemInfo
{
  const szchar *Text;        // メニュー項目の GetText キー。
  const szchar *Description; // GetCommandString で返す説明文字列の GetText キー。
  int  IconID;               // アイコン ID。
  bool UnderSubMenu;         // サブメニュー以下に表示するかどうか。
  bool NeedFormat;           // メニュー項目にファイル名をフォーマットするためのフォーマット文字列が含まれているかどうか（「DirName.7z に圧縮」のようなもの）。
  bool IsSubMenu;            // サブメニュー項目自体なら true（配列の最後の要素のみ true となり、それ以外は false）
};

// 割り当てられたコマンド ID と本来のメニュー項目との関連を管理するためのクラス。
class MenuItem
{
public:
  MenuItem(UINT uID, UINT infoIndex) : m_uID(uID), m_infoIndex(infoIndex) {}
  ~MenuItem() {}

  UINT GetID() const { return m_uID; }
  UINT GetIndex() const { return m_infoIndex; }

private:
  UINT m_uID;       // コマンド ID
  UINT m_infoIndex; // MenuItemInfo の配列における要素のインデックス
};
